import {Injectable} from "@angular/core";
import {preservationPlanningDipDataFileStatusHistoryNamespace} from "@preservation-planning/dip/stores/data-file/status-history/preservation-planning-dip-data-file-status-history.action";
import {AccessResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {DipDataFile} from "@preservation-planning/dip/models/dip-data-file.model";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface PreservationPlanningDipDataFileStatusHistoryStateModel extends StatusHistoryStateModel<DipDataFile> {
}

@Injectable()
@State<PreservationPlanningDipDataFileStatusHistoryStateModel>({
  name: LocalStateEnum.preservationPlanning_dip_dataFile_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class PreservationPlanningDipDataFileStatusHistoryState extends StatusHistoryState<PreservationPlanningDipDataFileStatusHistoryStateModel, DipDataFile> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationPlanningDipDataFileStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.dipDataFile;
  }
}
