import {Injectable} from "@angular/core";
import {environment} from "@environments/environment";
import {Aip} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {preservationPlanningDipAipNamespace} from "@preservation-planning/dip/stores/aip/preservation-planning-dip-aip.action";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
  QueryParameters,
} from "solidify-frontend";

export interface PreservationPlanningDipAipStateModel extends AssociationStateModel<Aip> {
}

@Injectable()
@State<PreservationPlanningDipAipStateModel>({
  name: LocalStateEnum.preservationPlanning_dip_aip,
  defaults: {
    ...defaultAssociationStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class PreservationPlanningDipAipState extends AssociationState<PreservationPlanningDipAipStateModel, Aip> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationPlanningDipAipNamespace,
      resourceName: ApiResourceNameEnum.AIP,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.dip;
  }
}
