import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationPlanningDipFormPresentational} from "@preservation-planning/dip/components/presentationals/dip-form/preservation-planning-dip-form.presentational";
import {PreservationPlanningDipFileDetailRoutable} from "@preservation-planning/dip/components/routables/dip-file-detail/preservation-planning-dip-file-detail.routable";
import {PreservationPlanningDipFileRoutable} from "@preservation-planning/dip/components/routables/dip-file/preservation-planning-dip-file.routable";
import {PreservationPlanningDipListRoutable} from "@preservation-planning/dip/components/routables/dip-list/preservation-planning-dip-list.routable";
import {PreservationPlanningDipMetadataRoutable} from "@preservation-planning/dip/components/routables/dip-metadata/preservation-planning-dip-metadata.routable";
import {PreservationPlanningDipRoutingModule} from "@preservation-planning/dip/preservation-planning-dip-routing.module";
import {PreservationPlanningDipAipState} from "@preservation-planning/dip/stores/aip/preservation-planning-dip-aip.state";
import {PreservationPlanningDipDataFileState} from "@preservation-planning/dip/stores/data-file/preservation-planning-dip-data-file.state";
import {PreservationPlanningDipDataFileStatusHistoryState} from "@preservation-planning/dip/stores/data-file/status-history/preservation-planning-dip-data-file-status-history.state";
import {PreservationPlanningDipState} from "@preservation-planning/dip/stores/preservation-planning-dip.state";
import {PreservationPlanningDipStatusHistoryState} from "@preservation-planning/dip/stores/status-history/preservation-planning-dip-status-history.state";
import {PreservationPlanningDipDetailEditRoutable} from "./components/routables/dip-detail-edit/preservation-planning-dip-detail-edit.routable";

const routables = [
  PreservationPlanningDipListRoutable,
  PreservationPlanningDipDetailEditRoutable,
  PreservationPlanningDipFileRoutable,
  PreservationPlanningDipFileDetailRoutable,
  PreservationPlanningDipMetadataRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  PreservationPlanningDipFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationPlanningDipRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationPlanningDipState,
      PreservationPlanningDipDataFileState,
      PreservationPlanningDipStatusHistoryState,
      PreservationPlanningDipDataFileStatusHistoryState,
      PreservationPlanningDipAipState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationPlanningDipModule {
}
