import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {
  AppRoutesEnum,
  PreservationPlanningRoutesEnum,
} from "@app/shared/enums/routes.enum";
import {DlcmRoutes} from "@app/shared/models/dlcm-route.model";
import {PreservationPlanningDipDetailEditRoutable} from "@preservation-planning/dip/components/routables/dip-detail-edit/preservation-planning-dip-detail-edit.routable";
import {PreservationPlanningDipFileDetailRoutable} from "@preservation-planning/dip/components/routables/dip-file-detail/preservation-planning-dip-file-detail.routable";
import {PreservationPlanningDipFileRoutable} from "@preservation-planning/dip/components/routables/dip-file/preservation-planning-dip-file.routable";
import {PreservationPlanningDipListRoutable} from "@preservation-planning/dip/components/routables/dip-list/preservation-planning-dip-list.routable";
import {PreservationPlanningDipMetadataRoutable} from "@preservation-planning/dip/components/routables/dip-metadata/preservation-planning-dip-metadata.routable";
import {PreservationPlanningDipState} from "@preservation-planning/dip/stores/preservation-planning-dip.state";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: DlcmRoutes = [
  {
    path: AppRoutesEnum.root,
    component: PreservationPlanningDipListRoutable,
    data: {},
  },
  {
    path: PreservationPlanningRoutesEnum.dipDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    redirectTo: PreservationPlanningRoutesEnum.dipDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId + AppRoutesEnum.separator + PreservationPlanningRoutesEnum.dipMetadata,
    pathMatch: "full",
  },
  {
    path: PreservationPlanningRoutesEnum.dipDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: PreservationPlanningDipDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: PreservationPlanningDipState.currentTitle,
    },
    children: [
      {
        path: PreservationPlanningRoutesEnum.dipMetadata,
        component: PreservationPlanningDipMetadataRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.metadata,
          noBreadcrumbLink: true,
        },
        children: [
          {
            path: PreservationPlanningRoutesEnum.dipEdit,
            data: {
              breadcrumb: LabelTranslateEnum.edit,
            },
            canDeactivate: [CanDeactivateGuard],
          },
        ],
      },
      {
        path: PreservationPlanningRoutesEnum.dipFiles,
        component: PreservationPlanningDipFileRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.files,
          noBreadcrumbLink: true,
        },
        children: [
          {
            path: AppRoutesEnum.paramId,
            component: PreservationPlanningDipFileDetailRoutable,
            data: {
              breadcrumb: LabelTranslateEnum.detail,
            },
          },
        ],
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PreservationPlanningDipRoutingModule {
}
