import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
  ViewChild,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {DepositFormPresentational} from "@deposit/components/presentationals/deposit-form/deposit-form.presentational";
import {
  Aip,
  Dip,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {PreservationPlanningDipAipState} from "@preservation-planning/dip/stores/aip/preservation-planning-dip-aip.state";
import {preservationPlanningDipActionNameSpace} from "@preservation-planning/dip/stores/preservation-planning-dip.action";
import {
  PreservationPlanningDipState,
  PreservationPlanningDipStateModel,
} from "@preservation-planning/dip/stores/preservation-planning-dip.state";
import {SharedAbstractDetailEditRoutable} from "@shared/components/routables/shared-abstract-detail-edit/shared-abstract-detail-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Observable} from "rxjs";
import {MemoizedUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-dip-metadata-routable",
  templateUrl: "./preservation-planning-dip-metadata.routable.html",
  styleUrls: ["./preservation-planning-dip-metadata.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class PreservationPlanningDipMetadataRoutable extends SharedAbstractDetailEditRoutable<Dip, PreservationPlanningDipStateModel> implements OnInit, OnDestroy {
  @Select(PreservationPlanningDipState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(PreservationPlanningDipState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  listAipObs: Observable<Aip[]> = MemoizedUtil.selected(this._store, PreservationPlanningDipAipState);

  @ViewChild("formPresentational")
  readonly formPresentational: DepositFormPresentational;

  readonly KEY_PARAM_NAME: keyof Dip & string = undefined;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.preservationPlanning_dip, preservationPlanningDipActionNameSpace, LocalStateEnum.preservationPlanning);
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  ngOnDestroy(): void {
    super.ngOnDestroy();
  }

  protected getSubResourceWithParentId(id: string): void {
  }
}
