import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {SharedAbstractListRoutable} from "@app/shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@app/shared/enums/field-type.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {appAuthorizedOrganizationalUnitNameSpace} from "@app/stores/authorized-organizational-unit/app-authorized-organizational-unit.action";
import {AppAuthorizedOrganizationalUnitState} from "@app/stores/authorized-organizational-unit/app-authorized-organizational-unit.state";
import {Enums} from "@enums";
import {
  Dip,
  OrganizationalUnit,
  PreservationJob,
} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {
  PreservationPlanningDipAction,
  preservationPlanningDipActionNameSpace,
} from "@preservation-planning/dip/stores/preservation-planning-dip.action";
import {PreservationPlanningDipStateModel} from "@preservation-planning/dip/stores/preservation-planning-dip.state";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {DataTableActions} from "@shared/models/data-table-actions.model";
import {RouterExtService} from "@shared/services/router-ext.service";
import {
  OrderEnum,
  Override,
  ResourceNameSpace,
  Sort,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-dip-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationPlanningDipListRoutable extends SharedAbstractListRoutable<Dip, PreservationPlanningDipStateModel> implements OnInit {
  readonly KEY_CREATE_BUTTON: string = undefined;
  readonly KEY_BACK_BUTTON: string = LabelTranslateEnum.backToPreservationPlanning;
  readonly KEY_PARAM_NAME: keyof Dip & string = undefined;

  appAuthorizedOrganizationalUnitSort: Sort<OrganizationalUnit> = {
    field: "name",
    order: OrderEnum.ascending,
  };
  appAuthorizedOrganizationalUnitNameSpace: ResourceNameSpace = appAuthorizedOrganizationalUnitNameSpace;
  appAuthorizedOrganizationalUnitState: typeof AppAuthorizedOrganizationalUnitState = AppAuthorizedOrganizationalUnitState;

  constructor(protected readonly _store: Store,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute,
              protected readonly _routerExt: RouterExtService,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog) {
    super(_store, _changeDetector, _route, _routerExt, _actions$, _dialog, LocalStateEnum.preservationPlanning_dip, preservationPlanningDipActionNameSpace, {
      canCreate: false,
    }, LocalStateEnum.preservationPlanning);
  }

  conditionDisplayEditButton(model: Dip | undefined): boolean {
    return false;
  }

  conditionDisplayDeleteButton(model: Dip | undefined): boolean {
    return false;
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "info.name" as any,
        header: LabelTranslateEnum.title,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "info.organizationalUnitId" as any,
        header: LabelTranslateEnum.organizationalUnit,
        type: FieldTypeEnum.searchableSingleSelect,
        order: OrderEnum.none,
        component: DataTableComponentEnum.organizationalUnitName,
        isFilterable: true,
        isSortable: true,
        resourceNameSpace: this.appAuthorizedOrganizationalUnitNameSpace,
        resourceState: this.appAuthorizedOrganizationalUnitState as any,
        searchableSingleSelectSort: this.appAuthorizedOrganizationalUnitSort,
        filterableField: "info.organizationalUnitId" as any,
        sortableField: "info.organizationalUnitId" as any,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: LabelTranslateEnum.updated,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.descending,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "info.status" as any,
        header: LabelTranslateEnum.status,
        type: FieldTypeEnum.singleSelect,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        translate: true,
        filterEnum: Enums.Package.StatusEnumTranslate,
        component: DataTableComponentEnum.status,
      },
    ];
  }

  @Override()
  protected defineActions(): DataTableActions<PreservationJob>[] {
    return [
      {
        logo: IconNameEnum.download,
        callback: (model: Dip) => this.download(model),
        placeholder: current => LabelTranslateEnum.download,
        displayOnCondition: (model: Dip) => true,
      },
    ];
  }

  private download(dip: Dip): void {
    this._store.dispatch(new PreservationPlanningDipAction.Download(dip.resId));
  }
}
