import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
  ViewChild,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Enums} from "@enums";
import {Dip} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {PreservationPlanningDipFormPresentational} from "@preservation-planning/dip/components/presentationals/dip-form/preservation-planning-dip-form.presentational";
import {DipDataFile} from "@preservation-planning/dip/models/dip-data-file.model";
import {PreservationPlanningDipDataFileAction} from "@preservation-planning/dip/stores/data-file/preservation-planning-dip-data-file.action";
import {PreservationPlanningDipDataFileState} from "@preservation-planning/dip/stores/data-file/preservation-planning-dip-data-file.state";
import {preservationPlanningDipActionNameSpace} from "@preservation-planning/dip/stores/preservation-planning-dip.action";
import {PreservationPlanningDipStateModel} from "@preservation-planning/dip/stores/preservation-planning-dip.state";
import {SharedAbstractDetailEditRoutable} from "@shared/components/routables/shared-abstract-detail-edit/shared-abstract-detail-edit.routable";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  AppRoutesEnum,
  PreservationPlanningRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {DataTableActions} from "@shared/models/data-table-actions.model";
import {DataTableColumns} from "@shared/models/data-table-columns.model";
import {Observable} from "rxjs";
import {
  isNullOrUndefined,
  MemoizedUtil,
  OrderEnum,
  QueryParameters,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-dip-file-routable",
  templateUrl: "./preservation-planning-dip-file.routable.html",
  styleUrls: ["./preservation-planning-dip-file.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationPlanningDipFileRoutable extends SharedAbstractDetailEditRoutable<Dip, PreservationPlanningDipStateModel> implements OnInit {
  isLoadingDataFileObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, PreservationPlanningDipDataFileState);
  listDataFileObs: Observable<DipDataFile[]> = MemoizedUtil.list(this._store, PreservationPlanningDipDataFileState);
  queryParametersObs: Observable<QueryParameters> = MemoizedUtil.queryParameters(this._store, PreservationPlanningDipDataFileState);

  isInDetailMode: boolean = false;

  @ViewChild("formPresentational")
  readonly formPresentational: PreservationPlanningDipFormPresentational;

  columns: DataTableColumns<DipDataFile>[];
  actions: DataTableActions<DipDataFile>[];

  readonly KEY_PARAM_NAME: keyof Dip & string = undefined;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.preservationPlanning_dip, preservationPlanningDipActionNameSpace, LocalStateEnum.preservationPlanning);

    this.columns = [
      {
        field: "fileName",
        header: LabelTranslateEnum.fileName,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isSortable: true,
        isFilterable: false,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: false,
        isSortable: true,
      },
      {
        field: "status",
        header: LabelTranslateEnum.status,
        type: FieldTypeEnum.singleSelect,
        order: OrderEnum.none,
        isSortable: false,
        isFilterable: false,
        translate: true,
        filterEnum: Enums.DataFile.StatusEnumTranslate,
        component: DataTableComponentEnum.status,
      },
      {
        field: "smartSize",
        header: LabelTranslateEnum.size,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        sortableField: "dataFile.fileSize" as any,
        filterableField: "dataFile.fileSize" as any,
        isSortable: false,
        isFilterable: false,
        translate: true,
        width: "100px",
      },
      {
        field: "complianceLevel",
        header: LabelTranslateEnum.complianceLevel,
        type: FieldTypeEnum.singleSelect,
        order: OrderEnum.none,
        isSortable: false,
        isFilterable: false,
        translate: true,
        component: DataTableComponentEnum.conformityLevelStar,
        filterEnum: Enums.DataFile.ComplianceLevelEnumTranslate,
      },
    ];

    this.actions = [
      {
        logo: IconNameEnum.resume,
        callback: (dipDataFile: DipDataFile) => this.resumeDataFile(this._resId, dipDataFile),
        placeholder: current => LabelTranslateEnum.resume,
        displayOnCondition: current => isNullOrUndefined(current) || current.status === Enums.DataFile.StatusEnum.IN_ERROR,
      },
      {
        logo: IconNameEnum.download,
        callback: (dipDataFile: DipDataFile) => this.downloadDataFile(this._resId, dipDataFile),
        placeholder: current => LabelTranslateEnum.download,
        displayOnCondition: (dipDataFile: DipDataFile) => true,
      },
    ];
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.getCurrentModelOnParent();
  }

  private getCurrentModelOnParent(): void {
    this._resId = this._route.snapshot.parent.paramMap.get(AppRoutesEnum.paramIdWithoutPrefixParam);
    this.getDepositById(this._resId);
  }

  private getDepositById(id: string): void {
    // this._store.dispatch(ResourceActionHelper.getById(preservationDipActionNameSpace, id, true));
    this.getSubResourceWithParentId(id);
  }

  getSubResourceWithParentId(id: string): void {
    // const queryParameter = new QueryParameters();
    // MappingObjectUtil.set(queryParameter.search.searchItems, "relativeLocation", "/");
    this._store.dispatch(new PreservationPlanningDipDataFileAction.GetAll(id, null, true));
    // this._store.dispatch(new PreservationDipDataFileAction.GetListFolder(id));
  }

  onQueryParametersEvent(queryParameters: QueryParameters): void {
    this._store.dispatch(new PreservationPlanningDipDataFileAction.ChangeQueryParameters(this._resId, queryParameters, true));
    // this._changeDetector.detectChanges(); // Allow to display spinner the first time
  }

  refresh(): void {
    this._store.dispatch(new PreservationPlanningDipDataFileAction.Refresh(this._resId));
  }

  download($event: DipDataFile): void {
    this._store.dispatch(new PreservationPlanningDipDataFileAction.Download(this._resId, $event));
  }

  showDetail(dipDataFile: DipDataFile): void {
    this._store.dispatch(new Navigate([RoutesEnum.preservationPlanningDipDetail, this._resId, PreservationPlanningRoutesEnum.dipFiles, dipDataFile.resId]));
  }

  private downloadDataFile(parentId: string, dataFile: DipDataFile): void {
    this._store.dispatch(new PreservationPlanningDipDataFileAction.Download(parentId, dataFile));
  }

  private resumeDataFile(parentId: string, dataFile: DipDataFile): void {
    this._store.dispatch(new PreservationPlanningDipDataFileAction.Resume(parentId, dataFile));
  }
}
