import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {DipDataFile} from "@preservation-planning/dip/models/dip-data-file.model";
import {preservationPlanningDipDataFileActionNameSpace} from "@preservation-planning/dip/stores/data-file/preservation-planning-dip-data-file.action";
import {PreservationPlanningDipDataFileState} from "@preservation-planning/dip/stores/data-file/preservation-planning-dip-data-file.state";
import {preservationPlanningDipDataFileStatusHistoryNamespace} from "@preservation-planning/dip/stores/data-file/status-history/preservation-planning-dip-data-file-status-history.action";
import {PreservationPlanningDipDataFileStatusHistoryState} from "@preservation-planning/dip/stores/data-file/status-history/preservation-planning-dip-data-file-status-history.state";
import {SharedAbstractFileAipDetailRoutable} from "@shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable";

@Component({
  selector: "dlcm-preservation-planning-dip-file-detail",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.scss"],
})
export class PreservationPlanningDipFileDetailRoutable extends SharedAbstractFileAipDetailRoutable<DipDataFile> implements OnInit {
  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store,
      _route,
      _actions$,
      _dialog,
      _changeDetector,
      PreservationPlanningDipDataFileState,
      preservationPlanningDipDataFileActionNameSpace,
      PreservationPlanningDipDataFileStatusHistoryState,
      preservationPlanningDipDataFileStatusHistoryNamespace);
  }
}
