import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationPlanningDepositState} from "@preservation-planning/deposit/stores/preservation-planning-deposit.state";
import {PreservationPlanningDepositRoutingModule} from "@preservation-planning/deposit/preservation-planning-deposit-routing.module";
import {PreservationPlanningDepositListRoutable} from "@preservation-planning/deposit/components/routables/deposit-list/preservation-planning-deposit-list.routable";

const routables = [
  PreservationPlanningDepositListRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationPlanningDepositRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationPlanningDepositState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationPlanningDepositModule {
}
