import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {RoutesEnum} from "@app/shared/enums/routes.enum";
import {TranslateService} from "@ngx-translate/core";
import {Store} from "@ngxs/store";
import {
  SharedAbstractHomeRoutable,
  SharedHomeTileModel,
} from "@shared/components/routables/shared-abstract-home/shared-abstract-home.routable";
import {ApplicationRolePermissionEnum} from "@shared/enums/application-role-permission.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {MARK_AS_TRANSLATABLE} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-home-routable",
  templateUrl: "./preservation-planning-home.routable.html",
  styleUrls: ["./preservation-planning-home.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationPlanningHomeRoutable extends SharedAbstractHomeRoutable {

  _tiles: SharedHomeTileModel[] = [
    {
      avatarIcon: IconNameEnum.deposit,
      titleToTranslate: LabelTranslateEnum.deposit,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("preservation.deposit.home.subtitle"),
      path: RoutesEnum.preservationPlanningDeposit,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.sip,
      titleToTranslate: LabelTranslateEnum.sip,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("preservation.sip.home.subtitle"),
      path: RoutesEnum.preservationPlanningSip,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.aip,
      titleToTranslate: LabelTranslateEnum.aip,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("preservation.aip.home.subtitle"),
      path: RoutesEnum.preservationPlanningAip,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.dip,
      titleToTranslate: LabelTranslateEnum.dip,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("preservation.dip.home.subtitle"),
      path: RoutesEnum.preservationPlanningDip,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.monitoring,
      titleToTranslate: LabelTranslateEnum.monitoring,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("preservation.monitoring.home.subtitle"),
      path: RoutesEnum.preservationPlanningMonitoring,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    {
      avatarIcon: IconNameEnum.jobs,
      titleToTranslate: LabelTranslateEnum.jobs,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("preservation.jobs.home.subtitle"),
      path: RoutesEnum.preservationPlanningJob,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.archivingStatus,
      titleToTranslate: LabelTranslateEnum.archivingStatus,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("preservation.aipStats.home.subtitle"),
      path: RoutesEnum.preservationPlanningAipStatuses,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.aipDownloaded,
      titleToTranslate: LabelTranslateEnum.aipDownloaded,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("preservation.aipDownloaded.home.subtitle"),
      path: RoutesEnum.preservationPlanningAipDownloaded,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
  ];

  constructor(protected readonly _store: Store,
              protected readonly _translate: TranslateService) {
    super(_store, _translate);
  }
}
