import {NgModule} from "@angular/core";
import {PreservationPlanningAipHomeRoutable} from "@preservation-planning/aip/components/routables/aip-home/preservation-planning-aip-home.routable";
import {PreservationPlanningAipRoutingModule} from "@preservation-planning/aip/preservation-planning-aip-routing.module";
import {SharedAipApproveDisposalDialog} from "@shared/features/aip/components/dialogs/aip-approve-disposal/shared-aip-approve-disposal.dialog";
import {SharedAipExtendRetentionDialog} from "@shared/features/aip/components/dialogs/aip-extend-retention/shared-aip-extend-retention.dialog";

const routables = [
  PreservationPlanningAipHomeRoutable,
];
const containers = [];
const dialogs = [
  SharedAipExtendRetentionDialog,
  SharedAipApproveDisposalDialog,
];
const presentationals = [];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    PreservationPlanningAipRoutingModule,
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationPlanningAipModule {
}
