import {Injectable} from "@angular/core";
import {
  ActivatedRouteSnapshot,
  CanActivate,
  Router,
} from "@angular/router";
import {
  Actions,
  ofActionCompleted,
  Store,
} from "@ngxs/store";
import {BaseResourceApiEnum} from "@shared/enums/api.enum";
import {
  AppRoutesEnum,
  PreservationPlanningRoutesEnum,
  RoutesEnum,
  SharedAipRoutesEnum,
} from "@shared/enums/routes.enum";
import {SharedAipAction} from "@shared/features/aip/stores/shared-aip.action";
import {RouteUtil} from "@shared/utils/route.util";
import {
  Observable,
  of,
} from "rxjs";
import {
  map,
  take,
} from "rxjs/operators";
import {
  isNullOrUndefined,
  isTrue,
} from "solidify-frontend";

@Injectable({
  providedIn: "root",
})
export class PreservationPlanningAipDetailGuardService implements CanActivate {
  constructor(private readonly _router: Router,
              private readonly _store: Store,
              private readonly _actions$: Actions) {
  }

  canActivate(route: ActivatedRouteSnapshot): Observable<boolean> {
    return this.isAuthorized(route);
  }

  private isAuthorized(route: ActivatedRouteSnapshot): Observable<boolean> {
    const idAip = route.params[AppRoutesEnum.paramIdWithoutPrefixParam];
    const storagionNodeId = +route.parent.params[PreservationPlanningRoutesEnum.storagionNumberWithoutPrefixParam];

    const storage = BaseResourceApiEnum.archivalStorageList.find(storagion => storagion.index === storagionNodeId);
    if (isNullOrUndefined(storage)) {
      this._router.navigate([RoutesEnum.preservationPlanningAip]);
      return of(false);
    }

    const url = RouteUtil.generateFullUrlStringFromActivatedRouteSnapshot(route);
    this._store.dispatch(new SharedAipAction.GetById(idAip, false, false, storagionNodeId, url));
    return this._actions$.pipe(
      ofActionCompleted(SharedAipAction.GetById),
      take(1),
      map((result) => {
        if (isTrue(result.result.successful)) {
          return true;
        } else {
          this._router.navigate([RoutesEnum.preservationPlanningAip, storagionNodeId, SharedAipRoutesEnum.aipNotFound, idAip]);
          return false;
        }
      }),
    );
  }
}
