import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {Enums} from "@enums";
import {Navigate} from "@ngxs/router-plugin";
import {Store} from "@ngxs/store";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";
import {BaseResourceApiEnum} from "@shared/enums/api.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AppRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Storage} from "@shared/models/storage.model";

@Component({
  selector: "dlcm-preservation-planning-aip-home-routable",
  templateUrl: "./preservation-planning-aip-home.routable.html",
  styleUrls: ["./preservation-planning-aip-home.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationPlanningAipHomeRoutable extends SharedAbstractRoutable {

  userRolesObs: Enums.UserApplicationRole.UserApplicationRoleEnum[];

  aipResources: AipResource[] = [];

  constructor(private readonly _store: Store) {
    super();
    this.userRolesObs = this._store.selectSnapshot((state: LocalStateModel) => state.application.userRoles);
  }

  navigate(path: RoutesEnum): void {
    this._store.dispatch(new Navigate([path]));
  }

  getAipResources(): AipResource[] {
    const storagionUrls: Storage[] = BaseResourceApiEnum.archivalStorageList;
    let i = 1;
    storagionUrls.forEach(storagion => {
      this.aipResources.push(
        {
          index: storagion.index,
          avatarIcon: IconNameEnum.storagion,
          titleToTranslate: LabelTranslateEnum.storagionInjectNumber,
          name: storagion.name,
          path: RoutesEnum.preservationPlanningAip + AppRoutesEnum.separator + storagion.index,
          isVisible: () => true,
          url: storagion.url,
        });
      i++;
    });
    return this.aipResources;
  }

  back(): void {
    this._store.dispatch(new Navigate([RoutesEnum.preservationPlanning]));
  }
}

interface AipResource {
  index: number;
  avatarIcon: IconNameEnum;
  titleToTranslate: string;
  path: RoutesEnum;
  isVisible: () => boolean;
  url: string;
  name: string;
}
