import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationPlanningAipStatusHomeRoutable} from "@preservation-planning/aip-status/components/routables/aip-status-home/preservation-planning-aip-status-home.routable";
import {PreservationPlanningAipStatusRoutingModule} from "@preservation-planning/aip-status/preservation-planning-aip-status-routing.module";
import {PreservationPlanningAipStatusState} from "@preservation-planning/aip-status/stores/preservation-planning-aip-status.state";

const routables = [
  PreservationPlanningAipStatusHomeRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationPlanningAipStatusRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationPlanningAipStatusState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationPlanningAipStatusModule {
}
