import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {Enums} from "@enums";
import {Navigate} from "@ngxs/router-plugin";
import {Store} from "@ngxs/store";
import {PreservationAipStatusAction} from "@preservation-planning/aip-status/stores/preservation-planning-aip-status.action";
import {PreservationPlanningAipStatusState} from "@preservation-planning/aip-status/stores/preservation-planning-aip-status.state";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {AipCopyList} from "@shared/models/business/aip-copy-list.model";
import {DataTableColumns} from "@shared/models/data-table-columns.model";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OrderEnum,
  QueryParameters,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-aip-status-home-routable",
  templateUrl: "./preservation-planning-aip-status-home.routable.html",
  styleUrls: ["./preservation-planning-aip-status-home.routable.scss"],
})
export class PreservationPlanningAipStatusHomeRoutable extends SharedAbstractPresentational implements OnInit {
  isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, PreservationPlanningAipStatusState);
  listObs: Observable<AipCopyList[]> = MemoizedUtil.list(this._store, PreservationPlanningAipStatusState);
  queryParametersObs: Observable<QueryParameters> = MemoizedUtil.queryParameters(this._store, PreservationPlanningAipStatusState);
  columns: DataTableColumns<AipCopyList>[];

  constructor(private readonly _store: Store,
              private readonly _changeDetector: ChangeDetectorRef) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.defineColumns();
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "resId",
        header: LabelTranslateEnum.identifier,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: false,
        isSortable: false,
      },
      {
        field: "copies",
        header: LabelTranslateEnum.nameLabel,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: false,
        isSortable: false,
        component: DataTableComponentEnum.aipStatusNamePresentational,
      },
      {
        field: "copies",
        header: LabelTranslateEnum.organizationalUnit,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        component: DataTableComponentEnum.aipStatusOrgUnitPresentational,
        isFilterable: false,
        isSortable: false,
      },
      {
        field: "status",
        header: LabelTranslateEnum.status,
        type: FieldTypeEnum.singleSelect,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: false,
        filterableField: "searchType",
        filterEnum: Enums.Aip.AipCopySearchTypeEnumTranslate,
        translate: true,
        component: DataTableComponentEnum.aipStatusSummaryPresentational,
      },
      {
        field: "creationDate",
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        filterableField: "creation.when",
        sortableField: "creation.when",
      },
    ];
  }

  getAll(queryParameters?: QueryParameters): void {
    this._store.dispatch(new PreservationAipStatusAction.GetAll(queryParameters, true));
  }

  onQueryParametersEvent(queryParameters: QueryParameters): void {
    this._store.dispatch(new PreservationAipStatusAction.ChangeQueryParameters(queryParameters, true));
    this._changeDetector.detectChanges(); // Allow to display spinner the first time
  }

  back(): void {
    this._store.dispatch(new Navigate([RoutesEnum.preservationPlanning]));
  }

  deleteCache(): void {
    this._store.dispatch(new PreservationAipStatusAction.DeleteCache());
  }
}
