import {Injectable} from "@angular/core";
import {
  OrderAllOrderState,
  OrderAllOrderStateModel,
} from "@app/features/order/features/all-order/stores/order-all-order.state";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {
  State,
  Store,
} from "@ngxs/store";
import {
  OrderMyOrderState,
  OrderMyOrderStateModel,
} from "@order/features/my-order/stores/order-my-order.state";
import {BaseStateModel} from "solidify-frontend";

export interface OrderStateModel extends BaseStateModel {
  order_allOrder: OrderAllOrderStateModel | undefined;
  order_myOrder: OrderMyOrderStateModel | undefined;
}

@Injectable()
@State<OrderStateModel>({
  name: LocalStateEnum.order,
  defaults: {
    isLoadingCounter: 0,
    order_allOrder: undefined,
    order_myOrder: undefined,
  },
  children: [
    OrderMyOrderState,
    OrderAllOrderState,
  ],
})
export class OrderState {
  constructor(protected store: Store) {
  }
}
