import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {OrderHomeRoutable} from "@app/features/order/components/routables/order-home/order-home.routable";
import {
  AppRoutesEnum,
  OrderRoutesEnum,
} from "@app/shared/enums/routes.enum";
import {ApplicationRolePermissionEnum} from "@shared/enums/application-role-permission.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ApplicationRoleGuardService} from "@shared/guards/application-role-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: OrderHomeRoutable,
    data: {},
  },
  {
    path: OrderRoutesEnum.myOrder,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./features/my-order/order-my-order.module").then(m => m.OrderMyOrderModule),
    data: {
      breadcrumb: LabelTranslateEnum.myOrders,
      permission: ApplicationRolePermissionEnum.userPermission,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: OrderRoutesEnum.allOrder,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./features/all-order/order-all-order.module").then(m => m.OrderAllOrderModule),
    data: {
      breadcrumb: LabelTranslateEnum.allOrders,
      permission: ApplicationRolePermissionEnum.adminPermission,
    },
    canActivate: [ApplicationRoleGuardService],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class OrderRoutingModule {

}
