import {Injectable} from "@angular/core";
import {Order} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {orderMyOrderStatusHistoryNamespace} from "@order/features/my-order/stores/status-history/order-my-order-status-history.action";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface OrderMyOrderStatusHistoryStateModel extends StatusHistoryStateModel<Order> {
}

@Injectable()
@State<OrderMyOrderStatusHistoryStateModel>({
  name: LocalStateEnum.order_myOrder_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class OrderMyOrderStatusHistoryState extends StatusHistoryState<OrderMyOrderStatusHistoryStateModel, Order> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: orderMyOrderStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.orders;
  }
}
