import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {StatusHistoryNamespace} from "@shared/stores/status-history/status-history-namespace.model";
import {StatusHistoryAction} from "@shared/stores/status-history/status-history.action";
import {TypeDefaultAction} from "solidify-frontend";

const state = LocalStateEnum.order_myOrder_statusHistory;

export namespace OrderMyOrderStatusHistoryAction {

  @TypeDefaultAction(state)
  export class History extends StatusHistoryAction.History {
  }

  @TypeDefaultAction(state)
  export class HistorySuccess extends StatusHistoryAction.HistorySuccess {
  }

  @TypeDefaultAction(state)
  export class HistoryFail extends StatusHistoryAction.HistoryFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends StatusHistoryAction.ChangeQueryParameters {
  }
}

export const orderMyOrderStatusHistoryNamespace: StatusHistoryNamespace = OrderMyOrderStatusHistoryAction;
