import {Injectable} from "@angular/core";
import {environment} from "@environments/environment";
import {Dip} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {orderMyOrderDipNamespace} from "@order/features/my-order/stores/dip/order-my-order-dip.action";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
  QueryParameters,
} from "solidify-frontend";

export interface OrderMyOrderDipStateModel extends AssociationStateModel<Dip> {
}

@Injectable()
@State<OrderMyOrderDipStateModel>({
  name: LocalStateEnum.order_myOrder_dip,
  defaults: {
    ...defaultAssociationStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class OrderMyOrderDipState extends AssociationState<OrderMyOrderDipStateModel, Dip> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: orderMyOrderDipNamespace,
      resourceName: ApiResourceNameEnum.DIP,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.orders;
  }
}
