import {Injectable} from "@angular/core";
import {environment} from "@environments/environment";
import {Aip} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {orderMyOrderAipNamespace} from "@order/features/my-order/stores/aip/order-my-order-aip.action";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
  QueryParameters,
} from "solidify-frontend";

export interface OrderMyOrderAipStateModel extends AssociationStateModel<Aip> {
}

@Injectable()
@State<OrderMyOrderAipStateModel>({
  name: LocalStateEnum.order_myOrder_aip,
  defaults: {
    ...defaultAssociationStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class OrderMyOrderAipState extends AssociationState<OrderMyOrderAipStateModel, Aip> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: orderMyOrderAipNamespace,
      resourceName: ApiResourceNameEnum.AIP,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.orders;
  }
}
