import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {OrderMyOrderDetailEditRoutable} from "@order/features/my-order/components/routables/my-order-detail-edit/order-my-order-detail-edit.routable";
import {OrderMyOrderListRoutable} from "@order/features/my-order/components/routables/my-order-list/order-my-order-list.routable";
import {OrderMyOrderPendingRoutable} from "@order/features/my-order/components/routables/my-order-pending/order-my-order-pending.routable";
import {OrderMyOrderState} from "@order/features/my-order/stores/order-my-order.state";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AppRoutesEnum,
  OrderRoutesEnum,
} from "@shared/enums/routes.enum";
import {DlcmRoutes} from "@shared/models/dlcm-route.model";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: DlcmRoutes = [
  {
    path: AppRoutesEnum.root,
    component: OrderMyOrderListRoutable,
    data: {},
  },
  {
    path: OrderRoutesEnum.myOrderDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: OrderMyOrderDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: OrderMyOrderState.currentTitle,
    },
    children: [
      {
        path: OrderRoutesEnum.myOrderEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    path: OrderRoutesEnum.myOrderDraft,
    component: OrderMyOrderPendingRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.pendingArchivesOrder,
    },
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class OrderMyOrderRoutingModule {
}
