import {
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {
  ActivatedRoute,
  Router,
} from "@angular/router";
import {AppCartAction} from "@app/stores/cart/app-cart.action";
import {AppCartState} from "@app/stores/cart/app-cart.state";
import {AppCartArchiveState} from "@app/stores/cart/archive/app-cart-archive.state";
import {Archive} from "@home/models/archive.model";
import {ArchiveAccessRightService} from "@home/services/archive-access-right.service";
import {Order} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {SecurityService} from "@shared/services/security.service";
import {Observable} from "rxjs";
import {MemoizedUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-my-order-pending-routable",
  templateUrl: "./order-my-order-pending.routable.html",
  styleUrls: ["./order-my-order-pending.routable.scss"],
})
export class OrderMyOrderPendingRoutable extends SharedAbstractRoutable {
  isLoadingCartObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, AppCartState as any);
  isLoadingArchiveObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, AppCartArchiveState);
  listObs: Observable<Archive[]> = MemoizedUtil.list(this._store, AppCartArchiveState);

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog,
              protected readonly _router: Router,
              private readonly _securityService: SecurityService,
              private readonly _archiveAccessRightService: ArchiveAccessRightService) {
    super();
  }

  submit(order: Order): void {
    this._store.dispatch(new AppCartAction.Submit(order));
  }

  deleteAllArchive(): void {
    this._store.dispatch(new AppCartAction.RemoveAll());
  }

  deleteArchive(archive: Archive): void {
    this._store.dispatch(new AppCartAction.RemoveToCart(archive.resId));
  }

  navigateToArchive(archive: Archive): void {
    this._store.dispatch(new Navigate([RoutesEnum.homeDetail, archive.resId]));
  }

  requestAccess(archive: Archive): void {
    this._archiveAccessRightService.requestAccessDataset(archive);
  }

  backToHomePage(): void {
    this._store.dispatch(new Navigate([RoutesEnum.orderMyOrder]));
  }
}
