import {Injectable} from "@angular/core";
import {Order} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {orderAllOrderStatusHistoryNamespace} from "@order/features/all-order/stores/status-history/order-all-order-status-history.action";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface OrderAllOrderStatusHistoryStateModel extends StatusHistoryStateModel<Order> {
}

@Injectable()
@State<OrderAllOrderStatusHistoryStateModel>({
  name: LocalStateEnum.order_allOrder_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class OrderAllOrderStatusHistoryState extends StatusHistoryState<OrderAllOrderStatusHistoryStateModel, Order> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: orderAllOrderStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.orders;
  }
}
