import {Injectable} from "@angular/core";
import {Navigate} from "@ngxs/router-plugin";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {
  OrderAllOrderOrderArchiveAction,
  orderAllOrderOrderArchiveActionNameSpace,
} from "@order/features/all-order/stores/order-archive/order-all-order-order-archive.action";
import {ApiActionEnum} from "@shared/enums/api-action.enum";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {OrderArchive} from "@shared/models/business/order-archive.model";
import {Observable} from "rxjs";
import {
  catchError,
  tap,
} from "rxjs/operators";
import {
  ApiService,
  CollectionTyped,
  defaultResourceStateInitValue,
  NotificationService,
  OverrideDefaultAction,
  QueryParameters,
  ResourceActionHelper,
  ResourceState,
  ResourceStateModel,
  SolidifyStateError,
  StoreUtil,
  urlSeparator,
} from "solidify-frontend";

export interface OrderAllOrderOrderArchiveStateModel extends ResourceStateModel<OrderArchive> {
}

@Injectable()
@State<OrderAllOrderOrderArchiveStateModel>({
  name: LocalStateEnum.order_allOrder_orderArchive,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(),
  },
  children: [],
})
export class OrderAllOrderOrderArchiveState extends ResourceState<OrderAllOrderOrderArchiveStateModel, OrderArchive> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: orderAllOrderOrderArchiveActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.orders;
  }

  @OverrideDefaultAction()
  @Action(OrderAllOrderOrderArchiveAction.GetAll)
  getAll(ctx: StateContext<OrderAllOrderOrderArchiveStateModel>, action: OrderAllOrderOrderArchiveAction.GetAll): Observable<CollectionTyped<OrderArchive>> {
    let reset = {};
    if (!action.keepCurrentContext) {
      reset = {
        list: undefined,
        total: 0,
      };
    }
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
      queryParameters: StoreUtil.getQueryParametersToApply(action.queryParameters, ctx),
      ...reset,
    });
    return this.apiService.get<OrderArchive>(this._urlResource + urlSeparator + action.resId + urlSeparator + ApiActionEnum.VIEW, ctx.getState().queryParameters)
      .pipe(
        StoreUtil.cancelUncompleted(ctx, this.actions$, [this._nameSpace.GetAll, Navigate]),
        tap((collection: CollectionTyped<OrderArchive>) => {
          ctx.dispatch(ResourceActionHelper.getAllSuccess<OrderArchive>(this._nameSpace, action, collection));
        }),
        catchError(error => {
          ctx.dispatch(ResourceActionHelper.getAllFail(this._nameSpace, action));
          throw new SolidifyStateError(this, error);
        }),
      );
  }
}
