import {Injectable} from "@angular/core";
import {Dip} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {orderAllOrderDipNamespace} from "@order/features/all-order/stores/dip/order-all-order-dip.action";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
  QueryParameters,
} from "solidify-frontend";

export interface OrderAllOrderDipStateModel extends AssociationStateModel<Dip> {
}

@Injectable()
@State<OrderAllOrderDipStateModel>({
  name: LocalStateEnum.order_allOrder_dip,
  defaults: {
    ...defaultAssociationStateInitValue(),
    queryParameters: new QueryParameters(),
  },
})
export class OrderAllOrderDipState extends AssociationState<OrderAllOrderDipStateModel, Dip> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: orderAllOrderDipNamespace,
      resourceName: ApiResourceNameEnum.DIP,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.orders;
  }
}
