import {Injectable} from "@angular/core";
import {Aip} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {orderAllOrderAipNamespace} from "@order/features/all-order/stores/aip/order-all-order-aip.action";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AccessResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
  QueryParameters,
} from "solidify-frontend";

export interface OrderAllOrderAipStateModel extends AssociationStateModel<Aip> {
}

@Injectable()
@State<OrderAllOrderAipStateModel>({
  name: LocalStateEnum.order_allOrder_aip,
  defaults: {
    ...defaultAssociationStateInitValue(),
    queryParameters: new QueryParameters(),
  },
})
export class OrderAllOrderAipState extends AssociationState<OrderAllOrderAipStateModel, Aip> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: orderAllOrderAipNamespace,
      resourceName: ApiResourceNameEnum.AIP,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.orders;
  }
}
