import {NgModule} from "@angular/core";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {OrderAllOrderFormPresentational} from "@order/features/all-order/components/presentationals/all-order-form/order-all-order-form.presentational";
import {OrderAllOrderCreateRoutable} from "@order/features/all-order/components/routables/all-order-create/order-all-order-create.routable";
import {OrderAllOrderListRoutable} from "@order/features/all-order/components/routables/all-order-list/order-all-order-list.routable";
import {OrderAllOrderRoutingModule} from "@order/features/all-order/order-all-order-routing.module";
import {OrderAllOrderAipState} from "@order/features/all-order/stores/aip/order-all-order-aip.state";
import {OrderAllOrderDipState} from "@order/features/all-order/stores/dip/order-all-order-dip.state";
import {OrderAllOrderState} from "@order/features/all-order/stores/order-all-order.state";
import {OrderAllOrderOrderArchiveState} from "@order/features/all-order/stores/order-archive/order-all-order-order-archive.state";
import {OrderAllOrderStatusHistoryState} from "@order/features/all-order/stores/status-history/order-all-order-status-history.state";
import {SharedModule} from "@shared/shared.module";
import {OrderAllOrderDetailEditRoutable} from "./components/routables/all-order-detail-edit/order-all-order-detail-edit.routable";

const routables = [
  OrderAllOrderListRoutable,
  OrderAllOrderDetailEditRoutable,
  OrderAllOrderCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  OrderAllOrderFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    OrderAllOrderRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      OrderAllOrderState,
      OrderAllOrderStatusHistoryState,
      OrderAllOrderAipState,
      OrderAllOrderDipState,
      OrderAllOrderOrderArchiveState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class OrderAllOrderModule {
}
