import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {OrderAllOrderCreateRoutable} from "@order/features/all-order/components/routables/all-order-create/order-all-order-create.routable";
import {OrderAllOrderDetailEditRoutable} from "@order/features/all-order/components/routables/all-order-detail-edit/order-all-order-detail-edit.routable";
import {OrderAllOrderListRoutable} from "@order/features/all-order/components/routables/all-order-list/order-all-order-list.routable";
import {OrderAllOrderState} from "@order/features/all-order/stores/order-all-order.state";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AppRoutesEnum,
  OrderRoutesEnum,
} from "@shared/enums/routes.enum";
import {DlcmRoutes} from "@shared/models/dlcm-route.model";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: DlcmRoutes = [
  {
    path: AppRoutesEnum.root,
    component: OrderAllOrderListRoutable,
    data: {},
  },
  {
    path: OrderRoutesEnum.allOrderDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: OrderAllOrderDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: OrderAllOrderState.currentTitle,
    },
    children: [
      {
        path: OrderRoutesEnum.allOrderEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    path: OrderRoutesEnum.allOrderCreate,
    component: OrderAllOrderCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class OrderAllOrderRoutingModule {
}
