import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ViewChild,
} from "@angular/core";
import {Order} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {orderAllOrderActionNameSpace} from "@order/features/all-order/stores/order-all-order.action";
import {
  OrderAllOrderState,
  OrderAllOrderStateModel,
} from "@order/features/all-order/stores/order-all-order.state";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedOrderActionNameSpace} from "@shared/stores/order/shared-order.action";
import {Observable} from "rxjs";
import {
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-order-all-order-create-routable",
  templateUrl: "./order-all-order-create.routable.html",
  styleUrls: ["../../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderAllOrderCreateRoutable extends SharedAbstractCreateRoutable<Order, OrderAllOrderStateModel> {
  @Select(OrderAllOrderState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(OrderAllOrderState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOrderActionNameSpace;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<Order>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.order_allOrder, orderAllOrderActionNameSpace, LocalStateEnum.order);
  }
}
