import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
  OnInit,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {Enums} from "@enums";
import {Order} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {
  KeyValue,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-order-all-order-form",
  templateUrl: "./order-all-order-form.presentational.html",
  styleUrls: ["./order-all-order-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderAllOrderFormPresentational extends SharedAbstractFormPresentational<Order> implements OnInit {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  orderStatusEnumValuesTranslate: KeyValue[] = Enums.Order.StatusEnumTranslate;
  queryTypeEnumValues: KeyValue[] = Enums.Order.QueryTypeEnumTranslate;

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.resId]: [undefined, []],
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.queryType]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.query]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.status]: [undefined, []],
    });
  }

  protected bindFormTo(order: Order): void {
    this.form = this._fb.group({
      [this.formDefinition.resId]: [order.resId, []],
      [this.formDefinition.name]: [order.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.queryType]: [order.queryType, [Validators.required, SolidifyValidator]],
      [this.formDefinition.query]: [order.query, [Validators.required, SolidifyValidator]],
      [this.formDefinition.status]: [order.status, []],
    });
    this.isValidWhenDisable = this.form.valid;
  }

  protected treatmentBeforeSubmit(order: Order): Order {
    delete order.resId;
    delete order.status;
    return order;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() resId: string;
  @PropertyName() name: string;
  @PropertyName() queryType: string;
  @PropertyName() query: string;
  @PropertyName() status: string;
}
