import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {RoutesEnum} from "@app/shared/enums/routes.enum";
import {LocalStateModel} from "@app/shared/models/local-state.model";
import {Enums} from "@enums";
import {Navigate} from "@ngxs/router-plugin";
import {Store} from "@ngxs/store";
import {ApplicationRolePermissionEnum} from "@shared/enums/application-role-permission.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {SessionStorageEnum} from "@shared/enums/session-storage.enum";
import {SessionStorageHelper} from "@shared/helpers/session-storage.helper";
import {PermissionUtil} from "@shared/utils/permission.util";
import {MARK_AS_TRANSLATABLE} from "solidify-frontend";

@Component({
  selector: "dlcm-order-home-routable",
  templateUrl: "./order-home.routable.html",
  styleUrls: ["./order-home.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderHomeRoutable extends SharedAbstractPresentational {

  userRolesObs: Enums.UserApplicationRole.UserApplicationRoleEnum[];

  orderResources: OrderResource[] = [
    {
      avatarIcon: IconNameEnum.myOrder,
      titleToTranslate: LabelTranslateEnum.myOrders,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("order.myOrder.home.subtitle"),
      path: RoutesEnum.orderMyOrder,
      isVisible: () => true,
      numberNew: () => SessionStorageHelper.getListItem(SessionStorageEnum.newOrderAvailable).length,
    },
    {
      avatarIcon: IconNameEnum.allOrder,
      titleToTranslate: LabelTranslateEnum.allOrders,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("order.allOrder.home.subtitle"),
      path: RoutesEnum.orderAllOrder,
      isVisible: () => PermissionUtil.isUserHavePermission(true, ApplicationRolePermissionEnum.adminPermission, this.userRolesObs),
    },
  ];

  constructor(private store: Store) {
    super();
    this.userRolesObs = this.store.selectSnapshot((state: LocalStateModel) => state.application.userRoles);
  }

  navigate(path: RoutesEnum): void {
    this.store.dispatch(new Navigate([path]));
  }

  getOrderResources(): OrderResource[] {
    return this.orderResources.filter((resource) => resource.isVisible() === true);
  }
}

interface OrderResource {
  avatarIcon: IconNameEnum;
  titleToTranslate: string;
  subtitleToTranslate: string;
  path: RoutesEnum;
  isVisible: () => boolean;
  numberNew?: () => number;
}
