import {ArchiveStatisticsDto} from "@home/models/archive-statistics-dto.model";
import {Archive} from "@home/models/archive.model";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {ViewModeTableEnum} from "@shared/enums/view-mode-table.enum";
import {
  BaseAction,
  BaseSubAction,
  CollectionTyped,
  MappingObject,
  QueryParameters,
} from "solidify-frontend";

const state = LocalStateEnum.home;

export namespace HomeAction {
  export class ChangeQueryParameters {
    static readonly type: string = `[${state}] Change Query Parameters`;

    constructor(public queryParameters?: QueryParameters) {
    }
  }

  export class Search {
    static readonly type: string = `[${state}] Search`;

    constructor(public resetPagination: boolean, public search?: string, public facetsSelected?: MappingObject<string[]>, public viewMode?: ViewModeTableEnum, public queryParameters?: QueryParameters) {
    }
  }

  export class SearchSuccess {
    static readonly type: string = `[${state}] Search Success`;

    constructor(public collection?: CollectionTyped<Archive> | null | undefined) {
    }
  }

  export class SearchFail {
    static readonly type: string = `[${state}] Search Fail`;
  }

  export class SearchRelativeArchive extends BaseAction {
    static readonly type: string = `[${state}] Search Relative Archive`;

    constructor(public archive: Archive) {
      super();
    }
  }

  export class SearchRelativeArchiveSuccess extends BaseSubAction<SearchRelativeArchive> {
    static readonly type: string = `[${state}] Search Relative Archive Success`;

    constructor(public parentAction: SearchRelativeArchive, public list: CollectionTyped<Archive> | null | undefined) {
      super(parentAction);
    }
  }

  export class SearchRelativeArchiveFail extends BaseSubAction<SearchRelativeArchive> {
    static readonly type: string = `[${state}] Search Relative Archive Fail`;
  }

  export class SearchDetail extends BaseAction {
    static readonly type: string = `[${state}] Search Detail`;

    constructor(public resId: string) {
      super();
    }
  }

  export class SearchDetailSuccess extends BaseSubAction<SearchDetail> {
    static readonly type: string = `[${state}] Search Detail Success`;

    constructor(public parentAction: SearchDetail, public model: Archive) {
      super(parentAction);
    }
  }

  export class SearchDetailFail extends BaseSubAction<SearchDetail> {
    static readonly type: string = `[${state}] Search Detail Fail`;
  }

  export class Download extends BaseAction {
    static readonly type: string = `[${state}] Download`;

    constructor(public archive: Archive) {
      super();
    }
  }

  export class DownloadStart extends BaseSubAction<Download> {
    static readonly type: string = `[${state}] Download Start`;
  }

  export class DownloadSuccess extends BaseSubAction<DownloadStart> {
    static readonly type: string = `[${state}] Download Success`;
  }

  export class DownloadFail extends BaseSubAction<DownloadStart> {
    static readonly type: string = `[${state}] Download Fail`;
  }

  export class CleanCurrent {
    static readonly type: string = `[${state}] Clean Current`;
  }

  export class GetStatistics extends BaseAction {
    static readonly type: string = `[${state}] Get Statistics`;

    constructor(public archiveId: string) {
      super();
    }
  }

  export class GetStatisticsSuccess extends BaseSubAction<GetStatistics> {
    static readonly type: string = `[${state}] Get Statistics Success`;

    constructor(public parentAction: GetStatistics, public archiveStatisticDto: ArchiveStatisticsDto) {
      super(parentAction);
    }
  }

  export class GetStatisticsFail extends BaseSubAction<GetStatistics> {
    static readonly type: string = `[${state}] Get Statistics Fail`;
  }
}
