import {ArchiveUserRating} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  CompositionAction,
  CompositionNameSpace,
  QueryParameters,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.home_archive_rating;

export namespace HomeArchiveRatingAction {
  @TypeDefaultAction(state)
  export class GetAll extends CompositionAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends CompositionAction.GetAllSuccess<ArchiveUserRating> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends CompositionAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends CompositionAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends CompositionAction.GetByIdSuccess<ArchiveUserRating> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends CompositionAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends CompositionAction.Update<ArchiveUserRating> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends CompositionAction.UpdateSuccess<ArchiveUserRating> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends CompositionAction.UpdateFail<ArchiveUserRating> {
  }

  @TypeDefaultAction(state)
  export class Create extends CompositionAction.Create<ArchiveUserRating> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends CompositionAction.CreateSuccess<ArchiveUserRating> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends CompositionAction.CreateFail<ArchiveUserRating> {
  }

  @TypeDefaultAction(state)
  export class Delete extends CompositionAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends CompositionAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends CompositionAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends CompositionAction.ChangeQueryParameters {
  }

  export class GetAllByCurrentUser extends BaseAction {
    static readonly type: string = `[${state}] Get All By Current User`;

    constructor(public parentId: string, public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }
}

export const homeArchiveRatingActionNameSpace: CompositionNameSpace = HomeArchiveRatingAction;
