import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {ArchiveMetadataPackages} from "@shared/models/business/archive-metadata-packages.model";
import {
  BaseAction,
  BaseSubAction,
} from "solidify-frontend";

const state = LocalStateEnum.home_archive_package;

export namespace HomeArchivePackageAction {
  export class GetById extends BaseAction {
    static readonly type: string = `[${state}] Get By Id`;

    constructor(public resId: string, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetByIdSuccess extends BaseSubAction<GetById> {
    static readonly type: string = `[${state}] Get By Id Success`;

    constructor(public parentAction: GetById, public model: ArchiveMetadataPackages) {
      super(parentAction);
    }
  }

  export class GetByIdFail extends BaseSubAction<GetById> {
    static readonly type: string = `[${state}] Get By Id Fail`;
  }
}
