import {DepositDataFile} from "@app/features/deposit/models/deposit-data-file.model";
import {ArchiveDataFile} from "@home/models/archive-data-file.model";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  BaseSubAction,
  CollectionTyped,
  QueryParameters,
} from "solidify-frontend";

const state = LocalStateEnum.home_archive_collection;

export namespace HomeArchiveCollectionAction {
  export class ChangeQueryParameters extends BaseAction {
    static readonly type: string = `[${state}] Change Query Parameters`;

    constructor(public parentId: string, public queryParameters: QueryParameters, public keepCurrentContext: boolean = false, public getAllAfterChange: boolean = true) {
      super();
    }
  }

  export class GetAll extends BaseAction {
    static readonly type: string = `[${state}] Get All`;

    constructor(public parentId: string, public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetAllSuccess extends BaseSubAction<GetAll> {
    static readonly type: string = `[${state}] Get All Success`;

    constructor(public parentAction: GetAll, public list: CollectionTyped<ArchiveDataFile>) {
      super(parentAction);
    }
  }

  export class GetAllFail extends BaseSubAction<GetAll> {
    static readonly type: string = `[${state}] Get All Fail`;
  }

  export class GetById extends BaseAction {
    static readonly type: string = `[${state}] Get By Id`;

    constructor(public parentId: string, public resId: string, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetByIdSuccess extends BaseSubAction<GetById> {
    static readonly type: string = `[${state}] Get By Id Success`;

    constructor(public parentAction: GetById, public model: ArchiveDataFile) {
      super(parentAction);
    }
  }

  export class GetByIdFail extends BaseSubAction<GetById> {
    static readonly type: string = `[${state}] Get By Id Fail`;
  }

  export class Refresh extends BaseAction {
    static readonly type: string = `[${state}] Refresh`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class RefreshSuccess extends BaseSubAction<Refresh> {
    static readonly type: string = `[${state}] Refresh Success`;
  }

  export class RefreshFail extends BaseSubAction<Refresh> {
    static readonly type: string = `[${state}] Refresh Fail`;
  }

  export class Download {
    static readonly type: string = `[${state}] Download`;

    constructor(public parentId: string, public dataFile: DepositDataFile) {
    }
  }
}
