import {Enums} from "@enums";
import {Metadata} from "@models";

export interface Archive {
  resId?: string;
  organizationalUnitId: string;
  title: string;
  description: string;
  yearPublicationDate: string;
  sizeDisplay: string;
  size: number;
  files: string;
  dataSensitivity: Enums.Deposit.DataSensitivityEnum;
  dataSensitivityToTranslate: string;
  accessLevel: Enums.Deposit.AccessEnum;
  accessLevelToTranslate: string;
  contributors: ArchiveContributor[];
  archiveMetadata: Metadata;
  withThumbnail: boolean;
  isCollection: boolean;
}

export interface ArchiveContributor {
  creatorName?: string;
  givenName?: string;
  familyName?: string;
  affiliation?: string[];
  orcid?: string;
}
