import {Enums} from "@enums";
import {Metadata} from "@models";

export interface ArchivePackage {
  resId?: string;
  organizationalUnitId: string;
  title: string;
  description: string;
  yearPublicationDate: string;
  sizeDisplay: string;
  size: number;
  files: string;
  dataSensitivity: Enums.Deposit.DataSensitivityEnum;
  dataSensitivityToTranslate: string;
  accessLevel: Enums.Deposit.AccessEnum;
  accessLevelToTranslate: string;
  contributors: string[];
  archiveMetadata: Metadata;
  withThumbnail: boolean;
}
