import {NgModule} from "@angular/core";
import {HomeRssDetailPresentational} from "@app/features/home/components/presentationals/home-rss-detail/home-rss-detail.presentational";
import {HomeRssWrapperPresentational} from "@app/features/home/components/presentationals/home-rss-wrapper/home-rss-wrapper.presentational";
import {HomeTwitterWidgetPresentational} from "@app/features/home/components/presentationals/home-tweet-detail/home-twitter-widget.presentational";
import {HomeTwitterWrapperPresentational} from "@app/features/home/components/presentationals/home-tweet-wrapper/home-tweeter-wrapper.presentational";
import {HomeRoutingModule} from "@app/features/home/home-routing.module";
import {TwitterService} from "@app/features/home/services/twitter.service";
import {HomeState} from "@app/features/home/stores/home.state";
import {SharedModule} from "@app/shared/shared.module";
import {HomeArchiveRestrictedRequestAccessDialog} from "@home/components/dialogs/archive-restricted-request-access/home-archive-restricted-request-access-dialog.component";
import {HomeSearchHelpDialog} from "@home/components/dialogs/home-search-help/home-search-help.dialog";
import {HomeArchiveDetailPresentational} from "@home/components/presentationals/home-archive-form/home-archive-detail.presentational";
import {HomeCarouselPresentational} from "@home/components/presentationals/home-carousel/home-carousel.presentational";
import {HomeMainButtonPresentational} from "@home/components/presentationals/home-main-button/home-main-button.presentational";
import {HomeMainPageContentPresentational} from "@home/components/presentationals/home-main-page-content/home-main-page-content.presentational";
import {HomePartnerImagePresentational} from "@home/components/presentationals/home-partner-image/home-partner-image.presentational";
import {HomePartnersPresentational} from "@home/components/presentationals/home-partners/home-partners.presentational";
import {HomeSearchBarPresentational} from "@home/components/presentationals/home-search-bar/home-search-bar.presentational";
import {HomeSearchFacetPresentational} from "@home/components/presentationals/home-search-facet/home-search-facet.presentational";
import {HomeArchiveCollectionListRoutable} from "@home/components/routables/home-archive-collection-list/home-archive-collection-list.routable";
import {HomeArchiveDetailRoutable} from "@home/components/routables/home-archive-detail/home-archive-detail.routable";
import {HomeArchiveFileDetailRoutable} from "@home/components/routables/home-archive-file-detail/home-archive-file-detail.routable";
import {HomeArchiveFileListRoutable} from "@home/components/routables/home-archive-file-list/home-archive-file-list.routable";
import {HomeArchiveNotFoundRoutable} from "@home/components/routables/home-archive-not-found/home-archive-not-found.routable";
import {HomePageRoutable} from "@home/components/routables/home-page/home-page.routable";
import {HomeSearchRoutable} from "@home/components/routables/home-search/home-search.routable";
import {HomeArchiveCollectionState} from "@home/stores/archive/collection/home-archive-collection.state";
import {HomeArchiveDataFileState} from "@home/stores/archive/data-file/home-archive-data-file.state";
import {HomeArchivePackageState} from "@home/stores/archive/package/home-archive-package.state";
import {HomeArchiveRatingState} from "@home/stores/archive/rating/home-archive-rating.state";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  HomePageRoutable,
  HomeSearchRoutable,
  HomeArchiveDetailRoutable,
  HomeArchiveFileListRoutable,
  HomeArchiveFileDetailRoutable,
  HomeArchiveCollectionListRoutable,
  HomeArchiveNotFoundRoutable,
];
const dialogs = [
  HomeArchiveRestrictedRequestAccessDialog,
  HomeSearchHelpDialog,
];
const containers = [];
const presentationals = [
  HomeSearchBarPresentational,
  HomeArchiveDetailPresentational,
  HomeTwitterWrapperPresentational,
  HomeTwitterWidgetPresentational,
  HomeRssWrapperPresentational,
  HomeRssDetailPresentational,
  HomeMainPageContentPresentational,
  HomePartnersPresentational,
  HomePartnerImagePresentational,
  HomeCarouselPresentational,
  HomeMainButtonPresentational,
  HomeSearchFacetPresentational,
];
const services = [
  TwitterService,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...presentationals,
    ...dialogs,
  ],
  imports: [
    SharedModule,
    HomeRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      HomeState,
      HomeArchiveCollectionState,
      HomeArchiveDataFileState,
      HomeArchivePackageState,
      HomeArchiveRatingState,
    ]),
  ],
  exports: [
    ...routables,
  ],
  entryComponents: [
    ...dialogs,
  ],
  providers: [
    ...services,
  ],
})
export class HomeModule {
}
