import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {
  AppRoutesEnum,
  HomePageRoutesEnum,
} from "@app/shared/enums/routes.enum";
import {DlcmRoutes} from "@app/shared/models/dlcm-route.model";
import {HomeArchiveCollectionListRoutable} from "@home/components/routables/home-archive-collection-list/home-archive-collection-list.routable";
import {HomeArchiveDetailRoutable} from "@home/components/routables/home-archive-detail/home-archive-detail.routable";
import {HomeArchiveFileDetailRoutable} from "@home/components/routables/home-archive-file-detail/home-archive-file-detail.routable";
import {HomeArchiveFileListRoutable} from "@home/components/routables/home-archive-file-list/home-archive-file-list.routable";
import {HomeArchiveNotFoundRoutable} from "@home/components/routables/home-archive-not-found/home-archive-not-found.routable";
import {HomePageRoutable} from "@home/components/routables/home-page/home-page.routable";
import {HomeSearchRoutable} from "@home/components/routables/home-search/home-search.routable";
import {HomeState} from "@home/stores/home.state";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ArchiveGuardService} from "@shared/guards/archive-guard.service";

const routes: DlcmRoutes = [
  {
    path: "",
    component: HomePageRoutable,
    data: {},
  },
  {
    path: HomePageRoutesEnum.search,
    component: HomeSearchRoutable,
  },
  {
    path: HomePageRoutesEnum.detail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: HomeArchiveDetailRoutable,
    canActivate: [ArchiveGuardService],
    data: {
      breadcrumbMemoizedSelector: HomeState.currentTitle,
    },
    children: [
      {
        path: HomePageRoutesEnum.files,
        component: HomeArchiveFileListRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.files,
        },
        children: [
          {
            path: AppRoutesEnum.paramIdDataFile,
            component: HomeArchiveFileDetailRoutable,
            data: {
              breadcrumb: LabelTranslateEnum.detail,
            },
          },
        ],
      },
      {
        path: HomePageRoutesEnum.collections,
        component: HomeArchiveCollectionListRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.collections,
        },
      },
    ],
  },
  {
    path: HomePageRoutesEnum.notFound + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: HomeArchiveNotFoundRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.archiveNotFound,
    },
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class HomeRoutingModule {
}
