import {
  ChangeDetectionStrategy,
  Component,
  OnInit,
} from "@angular/core";
import {
  ActivatedRoute,
  NavigationEnd,
  Router,
} from "@angular/router";
import {Navigate} from "@ngxs/router-plugin";
import {Store} from "@ngxs/store";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";
import {
  AppRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {
  distinctUntilChanged,
  filter,
  tap,
} from "rxjs/operators";

@Component({
  selector: "dlcm-shared-aip-not-found-routable",
  templateUrl: "./home-archive-not-found.routable.html",
  styleUrls: ["./home-archive-not-found.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomeArchiveNotFoundRoutable extends SharedAbstractRoutable implements OnInit {
  archiveId: string;

  constructor(private readonly _store: Store,
              private readonly _route: ActivatedRoute,
              private readonly _router: Router) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.retrieveAttribute();

    this.subscribe(this._router.events
      .pipe(
        filter(event => event instanceof NavigationEnd),
        distinctUntilChanged(),
        tap(event => {
          this.retrieveAttribute();
        }),
      ),
    );
  }

  retrieveAttribute(): void {
    this.archiveId = this._route.snapshot.paramMap.get(AppRoutesEnum.paramIdWithoutPrefixParam);
  }

  back(): void {
    this.navigate([RoutesEnum.homeSearch]);
  }

  private navigate(path: (string | number)[]): void {
    this._store.dispatch(new Navigate(path));
  }
}
