import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {ArchiveDataFile} from "@home/models/archive-data-file.model";
import {HomeArchiveDataFileAction} from "@home/stores/archive/data-file/home-archive-data-file.action";
import {HomeArchiveDataFileState} from "@home/stores/archive/data-file/home-archive-data-file.state";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {
  SharedFileAndAipDetailDialogModeEnum,
  SharedFileAndAipInformationDialogData,
} from "@shared/components/containers/shared-file-and-aip-information/shared-file-and-aip-information.container";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";
import {AppRoutesEnum} from "@shared/enums/routes.enum";
import {isNotNullOrUndefined} from "codelyzer/util/isNotNullOrUndefined";
import {Observable} from "rxjs";
import {
  filter,
  tap,
} from "rxjs/operators";
import {MemoizedUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-home-archive-file-detail-routable",
  templateUrl: "./home-archive-file-detail.routable.html",
  styleUrls: ["../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.scss"],
})
export class HomeArchiveFileDetailRoutable extends SharedAbstractRoutable implements OnInit {
  data: SharedFileAndAipInformationDialogData<ArchiveDataFile>;
  archiveDataFile: Observable<ArchiveDataFile> = MemoizedUtil.select(this._store, HomeArchiveDataFileState, state => state.current);
  mode: SharedFileAndAipDetailDialogModeEnum = SharedFileAndAipDetailDialogModeEnum.file;

  protected _parentId: string | undefined;
  protected _dataFileId: string | undefined;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this._retrieveResIdFromUrl();
    this._store.dispatch(new HomeArchiveDataFileAction.GetById(this._parentId, this._dataFileId));
    this.subscribe(this._observableCreateData());
  }

  protected _retrieveResIdFromUrl(): void {
    this._dataFileId = this._route.snapshot.paramMap.get(AppRoutesEnum.paramIdDataFileWithoutPrefixParam);
    this._parentId = this._route.parent.parent.snapshot.paramMap.get(AppRoutesEnum.paramIdWithoutPrefixParam);
  }

  protected _observableCreateData(): Observable<ArchiveDataFile> {
    return this.archiveDataFile.pipe(
      filter(resource => isNotNullOrUndefined(resource) && resource.resId === this._dataFileId),
      tap(resource => {
        this.data = {
          mode: this.mode,
          dataFile: resource,
          aip: undefined,
          resId: resource.resId,
          parentId: this._parentId,
          buttons: [],
        } as SharedFileAndAipInformationDialogData<ArchiveDataFile>;
        this._changeDetector.detectChanges();
      }),
    );
  }

}


