import {HttpClientTestingModule} from "@angular/common/http/testing";
import {NO_ERRORS_SCHEMA} from "@angular/core";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {ReactiveFormsModule} from "@angular/forms";
import {
  ActivatedRoute,
  Params,
} from "@angular/router";
import {TranslateService} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {ActivatedRouteStub} from "../../../../../../test-helpers/activated-route-stub";
import {MockTranslatePipe} from "../../../../../../test-helpers/mock-translate.pipe";
import {MockTranslateService} from "../../../../../../test-helpers/mock-translate.service";

import {HomeArchiveDetailRoutable} from "./home-archive-detail.routable";

xdescribe("HomeArchiveDetailRoutable", () => {
  let component: HomeArchiveDetailRoutable;
  let fixture: ComponentFixture<HomeArchiveDetailRoutable>;
  const activatedRoute: ActivatedRouteStub = new ActivatedRouteStub({id: "test"} as Params);
  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ReactiveFormsModule, HttpClientTestingModule, NgxsModule.forRoot([])],
      declarations: [HomeArchiveDetailRoutable, MockTranslatePipe],
      providers: [
        {
          provide: TranslateService,
          useClass: MockTranslateService,
        },
        {
          provide: ActivatedRoute,
          useValue: activatedRoute,
        },
      ],
      schemas: [NO_ERRORS_SCHEMA],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(HomeArchiveDetailRoutable);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });
});
