import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {TwitterChromeEnum} from "@app/features/home/enums/twitter-chrome.enum";
import {TwitterSourceTypeEnum} from "@app/features/home/enums/twitter-source-type.enum";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {environment} from "../../../../../../environments/environment";

@Component({
  selector: "dlcm-home-twitter-wrapper-presentational",
  templateUrl: "./home-tweeter-wrapper.presentational.html",
  styleUrls: ["./home-tweeter-wrapper.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomeTwitterWrapperPresentational extends SharedAbstractPresentational {
  readonly sourceType: string = TwitterSourceTypeEnum.profile;
  readonly screenName: string = environment.twitterAccount;
  readonly tweetLimit: number = environment.twitterTweetToDisplay;
  readonly chrome: TwitterChromeEnum[] = [TwitterChromeEnum.noborders];
}
