import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {
  Rss,
  RssItem,
} from "@app/features/home/models/rss.model";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";

@Component({
  selector: "dlcm-home-rss-wrapper-presentational",
  templateUrl: "./home-rss-wrapper.presentational.html",
  styleUrls: ["./home-rss-wrapper.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomeRssWrapperPresentational extends SharedAbstractPresentational {
  private readonly _maxNumberOfNewsToDisplay: number = 5; // environment.rssMaxNumberOfNewsToDisplay;
  @Input()
  rss: Rss;

  get rssItems(): RssItem[] {
    if (this.rss.channel.item.length > this._maxNumberOfNewsToDisplay) {
      return this.rss.channel.item.slice(0, this._maxNumberOfNewsToDisplay);
    }
    return this.rss.channel.item;
  }
}
