import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {RssItem} from "@app/features/home/models/rss.model";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-home-rss-detail-presentational",
  templateUrl: "./home-rss-detail.presentational.html",
  styleUrls: ["./home-rss-detail.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomeRssDetailPresentational extends SharedAbstractPresentational {
  @Input()
  item: RssItem;

  getImage(item: RssItem): string | undefined {
    if (isNullOrUndefined(item) || isNullOrUndefined(item.enclosure) || isNullOrUndefined(item.enclosure["@attributes"] || isNullOrUndefined(item.enclosure["@attributes"].url))) {
      return undefined;
    }
    return item.enclosure["@attributes"].url;
  }
}
