import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {isNotNullNorUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-home-partner-image",
  templateUrl: "./home-partner-image.presentational.html",
  styleUrls: ["./home-partner-image.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomePartnerImagePresentational extends SharedAbstractPresentational {
  @Input()
  image: ImageInfos;

  preventDefault($event: MouseEvent, url: string): void {
    if (isNotNullNorUndefined(url)) {
      return;
    }
    $event.preventDefault();
  }
}

export interface ImageInfos {
  imageName: string;
  altText: string;
  url: string;
}
