import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
} from "@angular/core";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {ObservableUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-home-main-page-content",
  templateUrl: "./home-main-page-content.presentational.html",
  styleUrls: ["./home-main-page-content.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomeMainPageContentPresentational extends SharedAbstractPresentational {
  private readonly _goToSearchBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("goToSearch")
  readonly goToSearchObs: Observable<void> = ObservableUtil.asObservable(this._goToSearchBS);

  private readonly _goToDepositOrLoginBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("goToDepositOrLogin")
  readonly goToDepositOrLoginObs: Observable<void> = ObservableUtil.asObservable(this._goToDepositOrLoginBS);

  @Input()
  carouselTiles: Node[];

  goToDeposit(): void {
    this._goToDepositOrLoginBS.next();
  }

  goToSearchResult(): void {
    this._goToSearchBS.next();
  }
}
