import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {IconNameEnum} from "@shared/enums/icon-name.enum";

@Component({
  selector: "dlcm-home-main-button",
  templateUrl: "./home-main-button.presentational.html",
  styleUrls: ["./home-main-button.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomeMainButtonPresentational extends SharedAbstractPresentational {
  @Input()
  titleToTranslate: string;

  @Input()
  subtitleToTranslate: string;

  @Input()
  iconName: IconNameEnum;
}
