import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  HostListener,
  Input,
  OnInit,
} from "@angular/core";
import {environment} from "@environments/environment";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {PollingHelper} from "@shared/helpers/polling.helper";

@Component({
  selector: "dlcm-home-carousel",
  templateUrl: "./home-carousel.presentational.html",
  styleUrls: ["./home-carousel.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomeCarouselPresentational extends SharedAbstractPresentational implements OnInit {
  activeTile: number = 0;
  skipNextChangeDueToHover: boolean = false;
  skipNextChangeDueToManualChangeOfTiles: boolean = false;

  private _listTiles: Node[];
  @Input()
  set listTiles(value: Node[]) {
    this._listTiles = value;
    this.activeTile = 0;
  }

  get listTiles(): Node[] {
    return this._listTiles;
  }

  @HostListener("mouseenter")
  onMouseEnter(): void {
    this.skipNextChangeDueToHover = true;
  }

  @HostListener("mouseleave")
  onMouseLeave(): void {
    this.skipNextChangeDueToHover = false;
  }

  constructor(private readonly _changeDetector: ChangeDetectorRef) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();

    this.subscribe(PollingHelper.startPollingObs({
      initialIntervalRefreshInSecond: environment.frequencyChangeCarouselTileInSecond,
      filter: () => {
        if (this.skipNextChangeDueToManualChangeOfTiles) {
          this.skipNextChangeDueToManualChangeOfTiles = false;
          return false;
        }
        if (this.skipNextChangeDueToHover) {
          return false;
        }
        return true;
      },
      actionToDo: () => this.changeActiveTile(),
    }));
  }

  setActive(number: number): void {
    this.activeTile = number;
    this.skipNextChangeDueToManualChangeOfTiles = true;
  }

  private changeActiveTile(): void {
    this.activeTile++;
    if (this.activeTile >= this.listTiles?.length) {
      this.activeTile = 0;
    }
    this._changeDetector.detectChanges();
  }
}
